/*
 * Decompiled with CFR 0.152.
 */
package com.engraving.demo.service;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class GcodeService {
    private Font loadFont(String fontName, int size) {
        try {
            String path = "/fonts/" + fontName + ".ttf";
            InputStream is = this.getClass().getResourceAsStream(path);
            if (is != null) {
                return Font.createFont(0, is).deriveFont(0, size);
            }
        }
        catch (Exception e) {
            System.out.println("Could not load custom font, falling back to system font: " + fontName);
        }
        return new Font(fontName, 0, size);
    }

    public String textToGcode(String text, String fontName, int fontSize) {
        StringBuilder gcode = new StringBuilder();
        gcode.append("G21 ; set units to mm\n");
        gcode.append("G90 ; absolute positioning\n");
        Font font = this.loadFont(fontName, fontSize);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector gv = font.createGlyphVector(frc, text);
        Shape outline = gv.getOutline(0.0f, 0.0f);
        Rectangle bounds = outline.getBounds();
        AffineTransform flip = new AffineTransform();
        flip.scale(1.0, -1.0);
        flip.translate(0.0, -bounds.getY() - bounds.getHeight());
        Shape flippedOutline = flip.createTransformedShape(outline);
        PathIterator pi = flippedOutline.getPathIterator(null, 0.5);
        double[] coords = new double[6];
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            switch (type) {
                case 0: {
                    gcode.append(String.format("G0 X%.2f Y%.2f\n", coords[0], coords[1]));
                    break;
                }
                case 1: {
                    gcode.append(String.format("G1 X%.2f Y%.2f F200\n", coords[0], coords[1]));
                    break;
                }
                case 4: {
                    gcode.append("G0 ; close path\n");
                }
            }
            pi.next();
        }
        gcode.append("M2 ; end program\n");
        return gcode.toString();
    }

    public List<String> streamMock(String text, String font, int size) {
        String gcode = this.textToGcode(text, font, size);
        String[] lines = gcode.split("\n");
        ArrayList<String> responses = new ArrayList<String>();
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            responses.add("Sent: " + line);
            responses.add("Device: ok");
        }
        return responses;
    }
}

