/*
 * Decompiled with CFR 0.152.
 */
package com.engraving.demo.controller;

import com.engraving.demo.dto.EngraveRequest;
import com.engraving.demo.service.GcodeService;
import java.util.List;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:5173"})
@RestController
@RequestMapping(value={"/api/engraver"})
public class EngraverController {
    private final GcodeService gcodeService;

    public EngraverController(GcodeService gcodeService) {
        this.gcodeService = gcodeService;
    }

    @PostMapping(value={"/generate-gcode"})
    public String generateGcode(@RequestBody EngraveRequest request) {
        return this.gcodeService.textToGcode(request.getText(), request.getFont(), request.getSize());
    }

    @PostMapping(value={"/stream"})
    public List<String> streamGcode(@RequestBody EngraveRequest request) {
        return this.gcodeService.streamMock(request.getText(), request.getFont(), request.getSize());
    }
}

